<?php

require_once(__DIR__ . '/utility.php');

function remove_all_sandbox($argv) {
	global $BACKEND;

	/* check number of arguments */
	if(count($argv) != 6) {
		echo "Usage: remove_all_sandbox ESXI_HOST ESXI_USERNAME ESXI_PASSWORD VM_PATH Sandbox_Prefix Sandbox_Count\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = $argv[0];
	$esxi_username = $argv[1];
	$esxi_password = $argv[2];
	$sandbox_image_path = $argv[3];
	$sandbox_prefix = $argv[4];
	$sandbox_count = $argv[5];

	$sandbox_storage_path = dirname(dirname($sandbox_image_path));

    // Escape variables since then they will be used in command line
    $escaped_esxi_username = escapeshellarg($esxi_username);
    $escaped_esxi_password = escapeshellarg($esxi_password);

	for($i=1; $i<=(int)$sandbox_count; $i++) {
		$sandbox_vmx_dir = $sandbox_storage_path . "/" . "$sandbox_prefix" . "$i" . "/";
		$sandbox_vmx_path = $sandbox_storage_path . "/" . "$sandbox_prefix" . "$i" . "/" . "$sandbox_prefix" . "$i" . ".vmx";
		stop_vm_and_wait($esxi_host, $esxi_username, $esxi_password, $sandbox_vmx_path);
		//$cmd_stop = "vmware-cmd --server $esxi_host --username $escaped_esxi_username --password $escaped_esxi_password $sandbox_vmx_path stop hard 2>&1";
		//exec($cmd_stop, $result_array, $return_value);
        
		unset($result_array);
		exec("$BACKEND unregister_esxi_vm $esxi_host $escaped_esxi_username $escaped_esxi_password $sandbox_vmx_path", $result_array, $return_value);
		if($return_value != 0) print_error($result_array, $return_value);

		// [workaround] : It appears that unregistering is an async call. We have to wait for a moment before
		//                deleting sandbox directory.
		//           TBD: Currently ssh_cmd.sh does not return remote exit code, so currently there is no trivil 
		//                way to check the existence of a directory.
		sleep(10);
        
		$cmd_removeDir = dirname(__FILE__) . "/ssh_cmd.sh $esxi_host $escaped_esxi_username $escaped_esxi_password \"rm -rf $sandbox_vmx_dir 2>&1\"";
		unset($result_array);
		exec($cmd_removeDir, $result_array, $return_value);
		if($return_value != 0) print_error($result_array, $return_value);
	}

	$sandbox_image_dir_to_delete = dirname($sandbox_image_path);
	$cmd_removeFile = dirname(__FILE__) . "/ssh_cmd.sh $esxi_host $escaped_esxi_username $escaped_esxi_password \"rm -rf $sandbox_image_dir_to_delete 2>&1\"";
	unset($result_array);
	exec($cmd_removeFile, $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	
	exit(0);
}

